#include <passport/infra/daemons/lbchdb/ut/common.h>

#include <passport/infra/daemons/lbchdb/src/yt_converters/auth/last_auth.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NLbchdb;
using namespace NPassport::NLbchdb::NYtConv;
using namespace NPassport::NLbchdb::NYtConv::NAuth;

Y_UNIT_TEST_SUITE(ConvertYtLastAuth) {
    Y_UNIT_TEST(CreateLastAuthEntry) {
        UNIT_ASSERT_VALUES_EQUAL(
            TLastAuthEntry::Create(NExtend::TAuthExtendedEntry{}),
            std::optional<TLastAuthEntry>());

        NExtend::TAuthExtendedEntry ext;
        ext.Row.Status = "successful";

        UNIT_ASSERT_VALUES_EQUAL(
            TLastAuthEntry::Create(ext),
            TLastAuthEntry({}));

        ext.Row.Uid = 42;
        ext.Row.Timestamp = TInstant::Seconds(100500);
        ext.Row.AuthType = "kek";
        UNIT_ASSERT_VALUES_EQUAL(
            TLastAuthEntry::Create(ext),
            TLastAuthEntry({
                .Uid = 42,
                .AuthType = "kek",
                .Timestamp = TInstant::Seconds(100500),
            }));
    }

    Y_UNIT_TEST(FilterLastAuthEntry) {
        TLastAuthFilter filter;

        filter.Add(TLastAuthEntry{.Uid = 42, .AuthType = "kek", .Timestamp = TInstant::Seconds(100500)});
        filter.Add(TLastAuthEntry{.Uid = 42, .AuthType = "kek", .Timestamp = TInstant::Seconds(100501)});
        filter.Add(TLastAuthEntry{.Uid = 42, .AuthType = "lol", .Timestamp = TInstant::Seconds(100500)});
        filter.Add(TLastAuthEntry{.Uid = 42, .AuthType = "lol", .Timestamp = TInstant::Seconds(100500)});
        filter.Add(TLastAuthEntry{.Uid = 43, .AuthType = "lol", .Timestamp = TInstant::Seconds(100500)});

        UNIT_ASSERT_VALUES_EQUAL(
            filter.ExtractEntries(),
            TLastAuthFilter::TEntries({
                {"42|kek", TLastAuthEntry{.Uid = 42, .AuthType = "kek", .Timestamp = TInstant::Seconds(100501)}},
                {"42|lol", TLastAuthEntry{.Uid = 42, .AuthType = "lol", .Timestamp = TInstant::Seconds(100500)}},
                {"43|lol", TLastAuthEntry{.Uid = 43, .AuthType = "lol", .Timestamp = TInstant::Seconds(100500)}},
            }));
    }
}
