#include <passport/infra/daemons/lbchdb/src/yt_converters/common.h>

#include <passport/infra/libs/cpp/utils/string/coder.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NLbchdb;
using namespace NPassport::NLbchdb::NYtConv;

Y_UNIT_TEST_SUITE(ConvertYtCommon) {
    Y_UNIT_TEST(compressWithGZip) {
        struct TCase {
            TString In;
            TString Out;
        };
        std::vector<TCase> cases = {
            {
                .In = "",
                .Out = "H4sIAAAAAAAAAwMAAAAAAAAAAAA=",
            },
            {
                .In = "some string to compress",
                .Out = "H4sIAAAAAAAAAyvOz01VKC4pysxLVyjJV0jOzy0oSi0uBgDd3n7BFwAAAA==",
            },
            {
                .In = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                .Out = "H4sIAAAAAAAAA0tMpB4AAEeAUz5MAAAA",
            },
        };

        for (const TCase& c : cases) {
            UNIT_ASSERT_VALUES_EQUAL_C(
                c.Out,
                NUtils::BinToBase64(TCompressor::Compress(c.In, TCompressor::ECompressionCodec::GZip)),
                c.In);
        }
    }

    Y_UNIT_TEST(compressWithBrotli) {
        struct TCase {
            TString In;
            TString Out;
        };
        std::vector<TCase> cases = {
            {
                .In = "",
                .Out = "awAD",
            },
            {
                .In = "some string to compress",
                .Out = "CwsAAARUOdKyL8Ol8Bcrs1TGOVd65iXOMQAD",
            },
            {
                .In = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                .Out = "iyUAACTCArFAigED",
            },
        };

        for (const TCase& c : cases) {
            UNIT_ASSERT_VALUES_EQUAL_C(
                c.Out,
                NUtils::BinToBase64(TCompressor::Compress(c.In, TCompressor::ECompressionCodec::Brotli)),
                c.In);
        }
    }

    Y_UNIT_TEST(compressWithZStd) {
        struct TCase {
            TString In;
            TString Out;
        };
        std::vector<TCase> cases = {
            {
                .In = "",
                .Out = "KLUv/SAAAQAA",
            },
            {
                .In = "some string to compress",
                .Out = "KLUv/QBYuQAAc29tZSBzdHJpbmcgdG8gY29tcHJlc3M=",
            },
            {
                .In = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                .Out = "KLUv/QBYRQAAEGFhAQCHAiw=",
            },
        };

        for (const TCase& c : cases) {
            UNIT_ASSERT_VALUES_EQUAL_C(
                c.Out,
                NUtils::BinToBase64(TCompressor::Compress(c.In, TCompressor::ECompressionCodec::ZStd)),
                c.In);
        }
    }
}
