#include <passport/infra/daemons/lbchdb/ut/common.h>

#include <passport/infra/daemons/lbchdb/src/yt_converters/mail_user_journal/users_history.h>

#include <passport/infra/libs/cpp/utils/string/coder.h>

#include <library/cpp/testing/unittest/registar.h>

#include <yt/yt/core/yson/writer.h>

using namespace NPassport;
using namespace NPassport::NLbchdb;
using namespace NPassport::NLbchdb::NYtConv::NMailUserJournal;

Y_UNIT_TEST_SUITE(ConvertYtMailUserJournalUsersHistory) {
#define TEST_DATA                                                     \
    {"abuseType", "abuseType_value"},                                 \
        {"affected", "affected_value"},                               \
        {"browser.name", "browser.name_value"},                       \
        {"browser.version", "browser.version_value"},                 \
        {"condition", "condition_value"},                             \
        {"destFid", "destFid_value"},                                 \
        {"deviceType", "deviceType_value"},                           \
        {"emailFrom", "emailFrom_value"},                             \
        {"fid", "fid_value"},                                         \
        {"filterIds", "filterIds_value"},                             \
        {"folder_symbol", "folder_symbol_value"},                     \
        {"ftype", "ftype_value"},                                     \
        {"hidden", "hidden_value"},                                   \
        {"internetProvider", "internetProvider_value"},               \
        {"ip", "ip_value"},                                           \
        {"lidText", "lidText_value"},                                 \
        {"lids", "lids_value"},                                       \
        {"mid", "mid_value"},                                         \
        {"msgStatus", "msgStatus_value"},                             \
        {"operationSystem.name", "operationSystem.name_value"},       \
        {"operationSystem.version", "operationSystem.version_value"}, \
        {"regionId", "regionId_value"},                               \
        {"spam_type", "spam_type_value"},                             \
        {"state", "state_value"},                                     \
        {"target", "target_value"},                                   \
    {                                                                 \
        "view_date", "view_date_value"                                \
    }

    Y_UNIT_TEST(buildData) {
        NParser::TMailUserJournalRow entry;
        UNIT_ASSERT_VALUES_EQUAL(ToYson({}),
                                 TUsersHistory::BuildData(entry));

        entry.Tskv = NRowParsers::TTskvRow(NRowParsers::TTskvRow::TFields{
            {"key#1", "value#1"},
            {"date", "100500"},
        });
        UNIT_ASSERT_VALUES_EQUAL(ToYson({}),
                                 TUsersHistory::BuildData(entry));

        entry.Tskv = NRowParsers::TTskvRow(NRowParsers::TTskvRow::TFields{
            {"key#1", "value#1"},
            {"date", "100500"},
            {"module", "module_value"},
            {"operation", "operation_value"},
            TEST_DATA,
        });
        UNIT_ASSERT_VALUES_EQUAL(ToYson({TEST_DATA}),
                                 TUsersHistory::BuildData(entry));

        UNIT_ASSERT_VALUES_EQUAL(
            "ewEWX2NvbXByZXNzZWQ9ewESYWJ1c2VUeXBlPXsBCHNpemU9Bg87AQp2YWx1ZT0BJgsHAAAkvlKQQRbJSuv6oXY2AAM7fTsBEGFmZmVjdGVkPXsBCHNpemU9Bg47AQp2YWx1ZT0BHosGAAAkvsqQRarqtFcDAzt9OwEYYnJvd3Nlci5uYW1lPXsBCHNpemU9BhI7AQp2YWx1ZT0BLIsIAAAEHHJoR/2CsKqQWcIC8ayGAQM7fTsBHmJyb3dzZXIudmVyc2lvbj17AQhzaXplPQYVOwEKdmFsdWU9ASQLCgAApFy+spBFGinrAraKDAM7fTsBEmNvbmRpdGlvbj17AQhzaXplPQYPOwEKdmFsdWU9ASALBwAAJL5qEWCqOpsA2AADO307AQ5kZXN0RmlkPXsBCHNpemU9Bg07AQp2YWx1ZT0BIgsGgGRlc3RGaWRfdmFsdWUDO307ARRkZXZpY2VUeXBlPXsBCHNpemU9BhA7AQp2YWx1ZT0BJIsHAAAkvlIQQhbJKtNK290NAzt9OwESZW1haWxGcm9tPXsBCHNpemU9Bg87AQp2YWx1ZT0BJgsHgGVtYWlsRnJvbV92YWx1ZQM7fTsBBmZpZD17AQhzaXplPQYJOwEKdmFsdWU9ASALBAAApL/IzNLEKFG1wAADO307ARJmaWx0ZXJJZHM9ewEIc2l6ZT0GDzsBCnZhbHVlPQEmCwcAAKSTvsjmFCGjFFWhtG0AAzt9OwEaZm9sZGVyX3N5bWJvbD17AQhzaXplPQYTOwEKdmFsdWU9ASoLCQAApL7MchFGGklLW39/l1iIAQM7fTsBCmZ0eXBlPXsBCHNpemU9Bgs7AQp2YWx1ZT0BHgsFAACkvsxikarO1QUZAzt9OwEMaGlkZGVuPXsBCHNpemU9Bgw7AQp2YWx1ZT0BHosFAAAkvoqQRarSFJoBAzt9OwEgaW50ZXJuZXRQcm92aWRlcj17AQhzaXplPQYWOwEKdmFsdWU9ATCLCgAApKG+3uSkIZNskhZ2as4NAa0yAAM7fTsBBGlwPXsBCHNpemU9Bgg7AQp2YWx1ZT0BHIsDAAAkv9LgYpOg2g0DO307AQ5saWRUZXh0PXsBCHNpemU9Bg07AQp2YWx1ZT0BIgsGgGxpZFRleHRfdmFsdWUDO307AQhsaWRzPXsBCHNpemU9Bgo7AQp2YWx1ZT0BHIsEgGxpZHNfdmFsdWUDO307AQZtaWQ9ewEIc2l6ZT0GCTsBCnZhbHVlPQEgCwQAAKS/yNLaxChRncAAAzt9OwESbXNnU3RhdHVzPXsBCHNpemU9Bg87AQp2YWx1ZT0BLAsHAADEY2ycoS/LshADRUVqTHtpAwM7fTsBKG9wZXJhdGlvblN5c3RlbS5uYW1lPXsBCHNpemU9Bho7AQp2YWx1ZT0BNIsMAAAEHHJoR/2CsLKQQ2bJykpDv4vxrJYDO307AS5vcGVyYXRpb25TeXN0ZW0udmVyc2lvbj17AQhzaXplPQYdOwEKdmFsdWU9ATALDgAApFy+upBDFmlEV9aVEvK7WF3ZAAM7fTsBEHJlZ2lvbklkPXsBCHNpemU9Bg47AQp2YWx1ZT0BIosGAAAkk77IipBNqrKkTg0DO307ARJzcGFtX3R5cGU9ewEIc2l6ZT0GDzsBCnZhbHVlPQEmCweAc3BhbV90eXBlX3ZhbHVlAzt9OwEKc3RhdGU9ewEIc2l6ZT0GCzsBCnZhbHVlPQEeCwWAc3RhdGVfdmFsdWUDO307AQx0YXJnZXQ9ewEIc2l6ZT0GDDsBCnZhbHVlPQEgiwUAACS+qpBFqkrdGs0AAzt9OwESdmlld19kYXRlPXsBCHNpemU9Bg87AQp2YWx1ZT0BJAsHAAAkvlIQRRbJyrpUnbMBAzt9O307fQ==",
            NUtils::BinToBase64(TUsersHistory::BuildData(entry, 7).AsStringBuf()));
    }

    Y_UNIT_TEST(buildEntry) {
        NParser::TMailUserJournalRow entry;

        UNIT_ASSERT_VALUES_EQUAL(
            TUserHistoryEntry({
                .ReversedUnixtime = 9223372036854775807,
                .Data = ToYson({}),
            }),
            TUsersHistory::BuildEntry(entry));

        entry.Uid = 10005000;
        entry.Date = 789456123;
        UNIT_ASSERT_VALUES_EQUAL(
            TUserHistoryEntry({
                .Uid = 10005000,
                .ReversedUnixtime = 9223372036065319684,
                .Data = ToYson({}),
            }),
            TUsersHistory::BuildEntry(entry));

        entry.Tskv = NRowParsers::TTskvRow(NRowParsers::TTskvRow::TFields{
            {"module", "module_value"},
            {"operation", "operation_value"},
            TEST_DATA,
        });
        UNIT_ASSERT_VALUES_EQUAL(
            TUserHistoryEntry({
                .Uid = 10005000,
                .ReversedUnixtime = 9223372036065319684,
                .Operation = "operation_value",
                .Module = "module_value",
                .Data = ToYson({TEST_DATA}),
            }),
            TUsersHistory::BuildEntry(entry));
    }

#undef TEST_DATA
}
