#include <passport/infra/daemons/lbchdb/src/yt_converters/push_subscription_converter.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NLbchdb;
using namespace NPassport::NLbchdb::NYtConv;

Y_UNIT_TEST_SUITE(ConvertPushSubscription) {
    Y_UNIT_TEST(counters) {
        TPushSubscriptionConverter conv;

        const TDuration width = TDuration::Hours(1);

        conv.Process(
            NParser::TPushSubscriptionRow{.Uid = 42, .Unixtime = TInstant::Seconds(100500)},
            width);
        conv.Process(
            NParser::TPushSubscriptionRow{.Uid = 42, .Unixtime = TInstant::Seconds(100501)},
            width);
        conv.Process(
            NParser::TPushSubscriptionRow{.Uid = 42, .Unixtime = TInstant::Seconds(1000501)},
            width);
        conv.Process(
            NParser::TPushSubscriptionRow{.Uid = 43, .Unixtime = TInstant::Seconds(100500)},
            width);

        TPushSubscriptionConverter::TRowsWithCounters rows = conv.GetRows();
        UNIT_ASSERT_VALUES_EQUAL(2, rows[NParser::TPushSubscriptionRow({.Uid = 42, .Unixtime = TInstant::Seconds(97200)})]);
        UNIT_ASSERT_VALUES_EQUAL(1, rows[NParser::TPushSubscriptionRow({.Uid = 42, .Unixtime = TInstant::Seconds(997200)})]);
        UNIT_ASSERT_VALUES_EQUAL(1, rows[NParser::TPushSubscriptionRow({.Uid = 43, .Unixtime = TInstant::Seconds(97200)})]);
        UNIT_ASSERT_VALUES_EQUAL(3, rows.size());
    }
}
