#include <passport/infra/daemons/lbchdb/src/yt_converters/tables_lifetime_config.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NLbchdb;
using namespace NPassport::NLbchdb::NYtConv;

Y_UNIT_TEST_SUITE(ConvertYtTableLifeTime) {
    Y_UNIT_TEST(IsDateActual) {
        TInstant now = TInstant::Now();

        TTablesLifeTimeConfig cfg{
            .FutureFrontier = TDuration::Days(1),
        };

        UNIT_ASSERT(!cfg.IsDateActual(now - TDuration::Days(3), TDuration::Days(3), now));
        UNIT_ASSERT(cfg.IsDateActual(now - TDuration::Days(2), TDuration::Days(3), now));
        UNIT_ASSERT(cfg.IsDateActual(now, TDuration::Days(3), now));
        UNIT_ASSERT(cfg.IsDateActual(now + TDuration::Hours(1), TDuration::Days(3), now));
        UNIT_ASSERT(!cfg.IsDateActual(now + TDuration::Days(1), TDuration::Days(3), now));
    }
}
