#! /bin/bash

set -e

function create_auths_table(){
    local CLUSTER=$1
    local TABLE=$2
    local TTL__SEC=$3

#    yt --proxy $CLUSTER remove -f $TABLE
    if [[ $(yt --proxy $CLUSTER exists $TABLE) == true ]]; then
        echo "$CLUSTER.$TABLE already exists"
        return
    fi
    echo "creating $CLUSTER.$TABLE..."

    yt --proxy $CLUSTER create --recursive table $TABLE
    yt --proxy $CLUSTER alter-table $TABLE --dynamic --schema '
    <
       "unique_keys" = %true;
       "strict" = %true;
    > [
       {
           "name" = "uid";
           "required" = %true;
           "type_v3" = "uint64";
           "sort_order" = "ascending";
       };
       {
           "name" = "reversed_timestamp";
           "required" = %true;
           "type_v3" = "int64";
           "sort_order" = "ascending";
       };
       {
           "name" = "unique_part";
           "required" = %true;
           "type_v3" = "string";
           "sort_order" = "ascending";
       };
       {
           "name" = "type";
           "required" = %false;
           "type_v3" = {"type_name" = "optional"; "item" = "string"};
       };
       {
           "name" = "status";
           "required" = %false;
           "type_v3" = {"type_name" = "optional"; "item" = "string"};
       };
       {
           "name" = "client_name";
           "required" = %false;
           "type_v3" = {"type_name" = "optional"; "item" = "string"};
       };
       {
           "name" = "data";
           "required" = %false;
           "type_v3" = {"type_name" = "optional"; "item" = "yson"};
       };
    ]
    '

    yt --proxy $CLUSTER set $TABLE/@atomicity none
    yt --proxy $CLUSTER set $TABLE/@desired_tablet_count 256
    yt --proxy $CLUSTER set $TABLE/@merge_rows_on_flush %true

    yt --proxy $CLUSTER set $TABLE/@compression_codec lz4
    yt --proxy $CLUSTER set $TABLE/@erasure_codec isa_lrc_12_2_2

    yt --proxy $CLUSTER set $TABLE/@min_data_versions 0
    yt --proxy $CLUSTER set $TABLE/@max_data_versions 1
    yt --proxy $CLUSTER set $TABLE/@min_data_ttl 0
    yt --proxy $CLUSTER set $TABLE/@max_data_ttl $(($TTL__SEC*1000))

    yt --proxy $CLUSTER set $TABLE/@chunk_writer '{erasure_store_original_block_checksums=%true}'

    yt --proxy $CLUSTER mount-table --sync $TABLE

    echo "creating $CLUSTER.$TABLE... Ok"
}

function create_monthly_tables(){
    local CLUSTER=$1
    local DIR=$2
    local TTL__SEC=$3

    local TABLE=$(date +%Y-%m -d " + 2 month")
    while : ; do
        TABLE=$(date -d "$TABLE-01 - 1 month" +%Y-%m)
        EXP_TIME__SEC=$(($(date +%s --date="$TABLE-01") + 2678400 + $TTL__SEC))
        [[ $EXP_TIME__SEC > $(date +%s) ]] || break

        if [[ $(yt --proxy $CLUSTER exists $DIR/$TABLE) == true ]]; then
            echo "$CLUSTER.$DIR/$TABLE already exists"
            continue
        fi

        echo "creating $CLUSTER.$DIR/$TABLE with expiration_time $(($EXP_TIME__SEC*1000)) | $(date --date=@$EXP_TIME__SEC)"
        create_auths_table $CLUSTER $DIR/$TABLE $TTL__SEC
        yt --proxy $CLUSTER set $DIR/$TABLE/@expiration_time $(($EXP_TIME__SEC*1000))
    done
}

create_monthly_tables seneca-sas "//home/passport-hdb/development/historydb/auths" 2678400
create_auths_table seneca-sas "//home/passport-hdb/development/historydb/failed_auths/failed_auths" 2678400

# create_monthly_tables seneca-vla "//home/passport-hdb/testing/historydb/auths" 5356800
# create_auths_table seneca-vla "//home/passport-hdb/testing/historydb/failed_auths/failed_auths" 2678400

# create_monthly_tables seneca-sas "//home/passport-hdb/production/historydb/auths" 64281600
# create_auths_table seneca-sas "//home/passport-hdb/production/historydb/failed_auths/failed_auths" 2678400

# create_monthly_tables seneca-vla "//home/passport-hdb/production/historydb/auths" 64281600
# create_auths_table seneca-vla "//home/passport-hdb/production/historydb/failed_auths/failed_auths" 2678400
