#! /bin/bash

set -e

create_table(){
    TABLE="$1"
    CLUSTER="$2"

#    yt --proxy $CLUSTER remove -f $TABLE
    yt --proxy $CLUSTER create --recursive --type table --path $TABLE
    yt --proxy $CLUSTER alter-table $TABLE --dynamic --schema '
<
   "unique_keys" = %true;
   "strict" = %true;
> [
   {
       "name" = "uid";
       "required" = %true;
       "type_v3" = "uint64";
       "sort_order" = "ascending";
   };
    {
      "name"       = "reversed_timestamp";
      "required"   = %true;
      "type_v3"    = "int64";
      "sort_order" = "ascending";
    };
    {
      "name" = "data";
      "type" = "any";
    };
]
'
    yt --proxy $CLUSTER set $TABLE/@atomicity none
    yt --proxy $CLUSTER set $TABLE/@desired_tablet_count 100
    yt --proxy $CLUSTER set $TABLE/@merge_rows_on_flush %true

    yt --proxy $CLUSTER set $TABLE/@min_data_versions 1
    yt --proxy $CLUSTER set $TABLE/@max_data_versions 1
    yt --proxy $CLUSTER set $TABLE/@min_data_ttl 0
    yt --proxy $CLUSTER set $TABLE/@max_data_ttl 0

    yt --proxy $CLUSTER set $TABLE/@erasure_codec isa_lrc_12_2_2

    yt --proxy $CLUSTER mount-table --sync $TABLE
}

create_table "//home/passport-hdb/development/historydb/restore/restore" seneca-sas
#create_table "//home/passport-hdb/testing/historydb/restore/restore" seneca-vla
#create_table "//home/passport-hdb/production/historydb/restore/restore" seneca-sas
#create_table "//home/passport-hdb/production/historydb/restore/restore" seneca-vla
