#! /bin/bash

set -e

create_table(){
    TABLE="$1"
    CLUSTER="$2"
    CODEC="$3"

    # yt --proxy $CLUSTER remove -f $TABLE
    yt --proxy $CLUSTER create --recursive --type table --path $TABLE
    yt --proxy $CLUSTER alter-table $TABLE --dynamic --schema '
<
   "unique_keys" = %true;
   "strict" = %true;
> [
   {
       "name" = "uid";
       "required" = %true;
       "type_v3" = "uint64";
       "sort_order" = "ascending";
   };
   {
       "name" = "authtype";
       "required" = %true;
       "type_v3" = "string";
       "sort_order" = "ascending";
   };
   {
       "name" = "timestamp";
       "required" = %true;
       "type_v3" = "uint64";
       "aggregate" = "max";
   };
]
'
    yt --proxy $CLUSTER set $TABLE/@atomicity none
    yt --proxy $CLUSTER set $TABLE/@desired_tablet_count 200
    yt --proxy $CLUSTER set $TABLE/@merge_rows_on_flush %true

    yt --proxy $CLUSTER set $TABLE/@min_data_versions 1
    yt --proxy $CLUSTER set $TABLE/@max_data_versions 1
    yt --proxy $CLUSTER set $TABLE/@min_data_ttl 0
    yt --proxy $CLUSTER set $TABLE/@max_data_ttl 0

    if [[ $CODEC != "-" ]]; then
        yt --proxy $CLUSTER set $TABLE/@erasure_codec $CODEC
    fi

    yt --proxy $CLUSTER mount-table --sync $TABLE
}

create_table "//home/passport-hdb/development/historydb/lastauth/lastauth" seneca-sas "-"
# create_table "//home/passport-hdb/testing/historydb/lastauth/lastauth" seneca-vla "-"
# create_table "//home/passport-hdb/production/historydb/lastauth/lastauth" seneca-sas "-"
# create_table "//home/passport-hdb/production/historydb/lastauth/lastauth" seneca-vla "-"
# create_table "//home/passport-hdb/production/historydb/lastauth/lastauth" seneca-man "isa_lrc_12_2_2"
