#!/bin/sh

set -x

YT_PROXY="seneca-vla"
YT_PATH="//home/passport-hdb/development/historydb/push-by-uid"
YT_TABLE="${YT_PATH}/202112"

YT_PROXY="${YT_PROXY}" yt create map_node "${YT_PATH}"
YT_PROXY="${YT_PROXY}" yt unmount-table "${YT_TABLE}"
YT_PROXY="${YT_PROXY}" yt remove "${YT_TABLE}"

YT_PROXY="${YT_PROXY}" yt create table "${YT_TABLE}" --attributes '{
  dynamic = true;
  schema  = <
    "unique_keys" = %true;
    "strict"      = %true;
  >
  [
    {
      "name"       = "uid";
      "type"       = "uint64";
      "sort_order" = "ascending";
      "required"   = %true;
    };
    {
      "name"       = "reversed_timestamp";
      "type"       = "int64";
      "sort_order" = "ascending";
      "required"   = %true;
    };
    {
      "name"       = "push_id";
      "type"       = "string";
      "sort_order" = "ascending";
      "required"   = %true;
    };
    {
      "name"       = "subscription_id";
      "type"       = "string";
      "sort_order" = "ascending";
      "required"   = %true;
    };
    {
      "name" = "dummy";
      "type" = "any";
    };
  ]
}'

YT_PROXY="${YT_PROXY}" yt set "${YT_TABLE}/@atomicity"           "none"
YT_PROXY="${YT_PROXY}" yt set "${YT_TABLE}/@merge_rows_on_flush" "%true"

YT_PROXY="${YT_PROXY}" yt set "${YT_TABLE}/@min_data_versions"   "0"
YT_PROXY="${YT_PROXY}" yt set "${YT_TABLE}/@max_data_versions"   "1"
YT_PROXY="${YT_PROXY}" yt set "${YT_TABLE}/@min_data_ttl"        "0"
YT_PROXY="${YT_PROXY}" yt set "${YT_TABLE}/@max_data_ttl"        "16070400000"

YT_PROXY="${YT_PROXY}" yt mount-table "${YT_TABLE}"
