#! /bin/sh

set -e

create_table(){
    TABLE="$1"
    TTL_IN_SECONDS="$2"
    CLUSTER="$3"

#    yt --proxy $CLUSTER remove -f $TABLE
    yt --proxy $CLUSTER create table $TABLE
    yt --proxy $CLUSTER alter-table $TABLE --dynamic --schema '
    <
       "unique_keys" = %true;
       "strict" = %true;
    > [
       {
           "name" = "uid";
           "required" = %true;
           "type_v3" = "uint64";
           "sort_order" = "ascending";
       };
       {
           "name" = "reversed_unixtime";
           "required" = %true;
           "type_v3" = "int64";
           "sort_order" = "ascending";
       };
       {
           "name" = "operation";
           "required" = %true;
           "type_v3" = "string";
           "sort_order" = "ascending";
       };
       {
           "name" = "module";
           "required" = %true;
           "type_v3" = "string";
           "sort_order" = "ascending";
       };
       {
           "name" = "data";
           "required" = %false;
           "type_v3" = {"type_name" = "optional"; "item" = "yson"};
       };
    ]
    '

    # All rows are independent events/entriess
    #https://yt.yandex-team.ru/docs/description/dynamic_tables/sorted_dynamic_tables#atomarnost
    yt --proxy $CLUSTER set $TABLE/@atomicity none
    yt --proxy $CLUSTER set $TABLE/@desired_tablet_count 512
    yt --proxy $CLUSTER set $TABLE/@merge_rows_on_flush %true

    yt --proxy $CLUSTER set $TABLE/@min_data_versions 0
    yt --proxy $CLUSTER set $TABLE/@max_data_versions 1
    yt --proxy $CLUSTER set $TABLE/@min_data_ttl 0
    yt --proxy $CLUSTER set $TABLE/@max_data_ttl $(($TTL_IN_SECONDS*1000))

    yt --proxy $CLUSTER mount-table $TABLE
}

run(){
#    create_table $1 $2 seneca-man
    create_table $1 $2 seneca-sas
#    create_table $1 $2 seneca-vla
}

run "//home/passport-hdb/development/historydb/users_history" 41708800
run "//home/passport-hdb/development/historydb/corp_users_history" 18408200

# Run force compaction. Use it carefully
# yt set $TABLE/@forced_compaction_revision 1; yt remount-table $TABLE

# TODO auto_compaction_period
