#! /bin/bash

set -e

function create_table(){
    local CLUSTER=$1
    local TABLE=$2
    local TTL__SEC=$3
    local SCHEMA=$4

#    yt --proxy $CLUSTER remove -f $TABLE
    if [[ $(yt --proxy $CLUSTER exists $TABLE) == true ]]; then
        echo "$CLUSTER.$TABLE already exists"
        return
    fi
    echo "creating $CLUSTER.$TABLE..."

    yt --proxy $CLUSTER create --recursive table $TABLE
    yt --proxy $CLUSTER alter-table $TABLE --dynamic --schema "$SCHEMA"

    yt --proxy $CLUSTER set $TABLE/@atomicity none
    yt --proxy $CLUSTER set $TABLE/@desired_tablet_count 256
    yt --proxy $CLUSTER set $TABLE/@merge_rows_on_flush %true

    yt --proxy $CLUSTER set $TABLE/@compression_codec lz4
    yt --proxy $CLUSTER set $TABLE/@erasure_codec isa_lrc_12_2_2

    yt --proxy $CLUSTER set $TABLE/@min_data_versions 0
    yt --proxy $CLUSTER set $TABLE/@max_data_versions 1
    yt --proxy $CLUSTER set $TABLE/@min_data_ttl 0
    yt --proxy $CLUSTER set $TABLE/@max_data_ttl $(($TTL__SEC*1000))

    yt --proxy $CLUSTER set $TABLE/@chunk_writer '{erasure_store_original_block_checksums=%true}'

    yt --proxy $CLUSTER mount-table --sync $TABLE

    echo "creating $CLUSTER.$TABLE... Ok"
}

function create_yasms_sms_history_table() {
    create_table $1 $2 $3 '
      <
         "unique_keys" = %true;
         "strict" = %true;
      >
      [
        {
          "name" = "global_sms_id";
          "required" = %true;
          "type_v3" = "string";
          "sort_order" = "ascending";
        };
        {
          "name" = "action";
          "required" = %true;
          "type_v3" = "string";
          "sort_order" = "ascending";
        };
        {
          "name" = "unixtime";
          "required" = %false;
          "type_v3" = {"type_name" = "optional"; "item" = "int64"};
        };
        {
          "name" = "uid";
          "required" = %false;
          "type_v3" = {"type_name" = "optional"; "item" = "uint64"};
        };
        {
          "name" = "phone";
          "required" = %false;
          "type_v3" = {"type_name" = "optional"; "item" = "uint64"};
        };
        {
          "name" = "data";
          "required" = %false;
          "type_v3" = {"type_name" = "optional"; "item" = "yson"};
        };
      ]
    '
}

function create_yasms_sms_history_by_phone_table() {
    create_table $1 $2 $3 '
      <
         "unique_keys" = %true;
         "strict" = %true;
      >
      [
        {
          "name" = "phone";
          "required" = %true;
          "type_v3" = "uint64";
          "sort_order" = "ascending";
        };
        {
          "name" = "reversed_timestamp";
          "required" = %true;
          "type_v3" = "int64";
          "sort_order" = "ascending";
        };
        {
          "name" = "global_sms_id";
          "required" = %true;
          "type_v3" = "string";
          "sort_order" = "ascending";
        };
        {
          "name" = "action";
          "required" = %true;
          "type_v3" = "string";
          "sort_order" = "ascending";
        };
        {
          "name" = "dummy";
          "type" = "any";
        };
      ]
    '
}

function create_yasms_sms_history_by_uid_table() {
    create_table $1 $2 $3 '
      <
         "unique_keys" = %true;
         "strict" = %true;
      >
      [
        {
          "name" = "uid";
          "required" = %true;
          "type_v3" = "uint64";
          "sort_order" = "ascending";
        };
        {
          "name" = "reversed_timestamp";
          "required" = %true;
          "type_v3" = "int64";
          "sort_order" = "ascending";
        };
        {
          "name" = "global_sms_id";
          "required" = %true;
          "type_v3" = "string";
          "sort_order" = "ascending";
        };
        {
          "name" = "action";
          "required" = %true;
          "type_v3" = "string";
          "sort_order" = "ascending";
        };
        {
          "name" = "dummy";
          "type" = "any";
        };
      ]
    '
}

function create_all_tables(){
    create_yasms_sms_history_table $1 "$2/sms_history/sms_history" $3
    create_yasms_sms_history_by_phone_table $1 "$2/sms_history_by_phone/sms_history_by_phone" $3
    create_yasms_sms_history_by_uid_table $1 "$2/sms_history_by_uid/sms_history_by_uid" $3
}

create_all_tables seneca-sas "//home/passport-hdb/development/historydb/yasms" 2678400
# create_all_tables seneca-vla "//home/passport-hdb/testing/historydb/yasms" 5356800
# create_all_tables seneca-sas "//home/passport-hdb/production/historydb/yasms" 94867200
# create_all_tables seneca-vla "//home/passport-hdb/production/historydb/yasms" 94867200
