import json
import sys

# https://lb.yandex-team.ru/docs/concepts/clusters_and_installations
# https://lb.yandex-team.ru/docs/concepts/security


SETTINGS = {
    "development": {
        "SELF_TVM_ID": "2024033",
        "LOGBROKER_CLIENT_ID": "phonekarma/dev/pharma",
        "LOGBROKER_TOPIC__BINDINGS": "phonekarma/testing/bindings",
        "LOGBROKER_TOPIC__YASMS_PRIVATE": "historydb2/testing/yasms_private",
        "MYSQL_SERVER": "cnt-dbm-test.passport.yandex.net",
        "PUSH_WORKERS": 2,
        "MAX_UNCOMMITTED_SIZE": 80 * 1024 * 1024,
    },
    "testing": {
        "SELF_TVM_ID": "2024369",
        "LOGBROKER_CLIENT_ID": "phonekarma/testing/pharma",
        "LOGBROKER_TOPIC__BINDINGS": "phonekarma/testing/bindings",
        "LOGBROKER_TOPIC__YASMS_PRIVATE": "historydb2/testing/yasms_private",
        "MYSQL_SERVER": "pharma-dbm.passport.yandex.net",
        "PUSH_WORKERS": 2,
        "MAX_UNCOMMITTED_SIZE": 80 * 1024 * 1024,
    },
    "production": {
        "SELF_TVM_ID": "2024031",
        "LOGBROKER_CLIENT_ID": "phonekarma/production/pharma",
        "LOGBROKER_TOPIC__BINDINGS": "phonekarma/production/bindings",
        "LOGBROKER_TOPIC__YASMS_PRIVATE": "historydb2/production/yasms_private",
        "MYSQL_SERVER": "pharma-dbm.passport.yandex.net",
        "PUSH_WORKERS": 8,
        "MAX_UNCOMMITTED_SIZE": 160 * 1024 * 1024,
    },
}

SETTINGS_FROM_FILE = {
    "MYSQL_LOGIN": "/etc/yandex/passport-lbcpharma/mysql.login",
    "MYSQL_PASSWORD": "/etc/yandex/passport-lbcpharma/mysql.password",
    "TVM_SECRET": "/etc/yandex/passport-lbcpharma/tvm.secret",
}


def do(template, env):
    if env not in SETTINGS:
        raise Exception("env '%s' is unknown" % env)

    setts = SETTINGS[env]
    for key, value in setts.items():
        template = template.replace('<<%s>>' % key, str(value))

    for key, value in SETTINGS_FROM_FILE.items():
        with open(value) as f:
            template = template.replace('<<%s>>' % key, str(f.read()))

    if '<<' in template or '>>' in template:
        raise Exception("some options were not specified: %s\n" % template)

    print(template)


if __name__ == '__main__':
    if len(sys.argv) != 3:
        print("Usage: %s <template_file> <env>" % (sys.argv[0]), file=sys.stderr)
        sys.exit(1)

    with open(sys.argv[1]) as f:
        template = f.read()
        assert len(template) > 0

    do(template, sys.argv[2])
