#pragma once

#include "converters/common.h"

#include <passport/infra/libs/cpp/dbpool/handle.h>
#include <passport/infra/libs/cpp/unistat/builder.h>
#include <passport/infra/libs/cpp/utils/regular_task.h>

#include <util/stream/format.h>

#include <random>

namespace NPassport::NLbcPharma {
    class TRandomSleepTask: public NUtils::TRegularTask {
    public:
        TRandomSleepTask(TFunc f, TDuration period, const TString& name)
            : NUtils::TRegularTask(std::move(f), period, name)
        {
        }

        TDuration GetTimeToSleep() const override {
            ui64 halfPeriod = Period_.load(std::memory_order_relaxed).MilliSeconds() / 2;
            return TDuration::MilliSeconds(halfPeriod + rand() % (halfPeriod));
        }
    };

    struct TCleanerSettings {
        TDuration MaxCleanInterval = TDuration::MilliSeconds(1000);
        TDuration DataTtl = TDuration::Days(367);
        ui64 BatchSize = 50;
    };

    class TCleaner {
    public:
        explicit TCleaner(std::shared_ptr<NDbPool::TDbPool> db, TCleanerSettings&& settings = {});

        void Run();

        void AddUnistat(NUnistat::TBuilder& builder) const;

    private:
        size_t DeleteBatch(TStringBuf table, TStringBuf column, time_t cutoff) const;

        std::shared_ptr<NDbPool::TDbPool> Db_;

        TCleanerSettings Settings_;

        std::unique_ptr<TRandomSleepTask> Task_;

        NUnistat::TSignalDiff<> DeletedRowsBindings_ = {"cleaner.deleted_rows.bindings"};
        NUnistat::TSignalDiff<> DeletedRowsUsages_ = {"cleaner.deleted_rows.usages"};
    };

    using TCleanerPtr = std::unique_ptr<TCleaner>;
}
