#include "bindings.h"

#include "common.h"

namespace NPassport::NLbcPharma::NConverter {
    static const TString TABLE_NAME = "bindings";

    TString TBindingsQueryBuilder::Build(const std::vector<TQuery>& queries) const {
        return BuildImpl(queries,
                         "INSERT INTO bindings(phonenum, uid, ip, ua, add_ts) VALUES ",
                         " ON DUPLICATE KEY UPDATE phonenum=phonenum");
    }

    TBindingsConverter::TBindingsConverter(NDbPool::TBlockingHandle& h)
        : Sql_(h)
        , Builder_(std::make_shared<TBindingsQueryBuilder>())
    {
    }

    void TBindingsConverter::Process(NParser::TBindingsRow&& row) {
        Result_.Add(TABLE_NAME,
                    Builder_,
                    TQuery{
                        .SerializedEntity = SerializeEntity(row),
                    });
    }

    void TBindingsConverter::Reserve(size_t size) {
        Result_.Reserve(TABLE_NAME, Builder_, size);
    }

    TQueries TBindingsConverter::Finish() {
        return std::move(Result_);
    }

    TString TBindingsConverter::SerializeEntity(const NParser::TBindingsRow& row) {
        TString res = NUtils::CreateStrExt(
            512,
            "(",
            row.Phonenum,
            ",",
            row.Uid,
            ",",
            "'", GetIp(row.UserIp), "'",
            ",",
            "'", PrepareUserAgent(Sql_, row.UserAgent), "'",
            ",",
            InvertTs(row.Ts),
            ")");

        return res;
    }
}
