#pragma once

#include <passport/infra/daemons/lbcpharma/src/query.h>
#include <passport/infra/daemons/lbcpharma/src/parsers/bindings.h>

namespace NPassport::NDbPool {
    class TBlockingHandle;
}

namespace NPassport::NLbcPharma::NConverter {
    class TBindingsQueryBuilder: public TBaseQueryBuilder {
    public:
        TString Build(const std::vector<TQuery>& queries) const override;
    };

    class TBindingsConverter {
    public:
        TBindingsConverter(NDbPool::TBlockingHandle& h);

        void Process(NParser::TBindingsRow&& row);
        void Reserve(size_t size);
        TQueries Finish();

        TString SerializeEntity(const NParser::TBindingsRow& row);

    private:
        TQueries Result_;
        NDbPool::TBlockingHandle& Sql_;
        TQueryBuilderPtr Builder_;
    };
}
