#pragma once

#include <passport/infra/libs/cpp/dbpool/handle.h>
#include <passport/infra/libs/cpp/utils/ipaddr.h>

namespace NPassport::NLbcPharma::NConverter {
    inline TString PrepareUserAgent(NDbPool::TBlockingHandle& h,
                                    const TString& userAgent,
                                    size_t maxSize = 300) {
        TStringBuf buf(userAgent);
        buf.Trunc(maxSize);
        return h.EscapeQueryParam(buf);
    }

    inline time_t InvertTs(time_t time) {
        return std::numeric_limits<ui32>::max() - time;
    }

    inline TString GetIp(const std::optional<NUtils::TIpAddr>& ip) {
        return ip ? ip->ToString() : TString();
    }
}
