#include "yasms_private.h"

#include "common.h"

namespace NPassport::NLbcPharma::NConverter {
    static const TString TABLE_NAME = "usages";

    TString TYasmsPrivateQueryBuilder::Build(const std::vector<TQuery>& queries) const {
        return BuildImpl(queries,
                         "INSERT INTO usages(phonenum, ip, ua, ts) VALUES ",
                         " ON DUPLICATE KEY UPDATE phonenum=phonenum");
    }

    TYasmsPrivateConverter::TYasmsPrivateConverter(NDbPool::TBlockingHandle& h)
        : Sql_(h)
        , Builder_(std::make_shared<TYasmsPrivateQueryBuilder>())
    {
    }

    void TYasmsPrivateConverter::Process(NParser::TYasmsPrivateRow&& row) {
        Result_.Add(TABLE_NAME,
                    Builder_,
                    TQuery{
                        .SerializedEntity = SerializeEntity(row),
                    });
    }

    void TYasmsPrivateConverter::Reserve(size_t size) {
        Result_.Reserve(TABLE_NAME, Builder_, size);
    }

    TQueries TYasmsPrivateConverter::Finish() {
        return std::move(Result_);
    }

    TString TYasmsPrivateConverter::SerializeEntity(const NParser::TYasmsPrivateRow& row) {
        TString res = NUtils::CreateStrExt(
            512,
            "(",
            row.Phonenum,
            ",",
            "'", GetIp(row.UserIp), "'",
            ",",
            "'", PrepareUserAgent(Sql_, row.UserAgent), "'",
            ",",
            InvertTs(row.Ts),
            ")");

        return res;
    }
}
