#pragma once

#include <passport/infra/daemons/lbcpharma/src/query.h>
#include <passport/infra/daemons/lbcpharma/src/parsers/yasms_private.h>

namespace NPassport::NDbPool {
    class TBlockingHandle;
}

namespace NPassport::NLbcPharma::NConverter {
    class TYasmsPrivateQueryBuilder: public TBaseQueryBuilder {
    public:
        TString Build(const std::vector<TQuery>& queries) const override;
    };

    class TYasmsPrivateConverter {
    public:
        TYasmsPrivateConverter(NDbPool::TBlockingHandle& h);

        void Process(NParser::TYasmsPrivateRow&& row);
        void Reserve(size_t size);
        TQueries Finish();

        TString SerializeEntity(const NParser::TYasmsPrivateRow& row);

    private:
        TQueries Result_;
        NDbPool::TBlockingHandle& Sql_;
        TQueryBuilderPtr Builder_;
    };
}
