#include "data_pusher.h"

#include <passport/infra/libs/cpp/dbpool/handle.h>

#include <util/string/join.h>

namespace NPassport::NLbcPharma {
    TDataPusher::TDataPusher(TLbReaderPoolPtr readerPool)
        : TBase(NLb::NPusher::TBaseSettings{
                    .SignalPrefix = "mysql",
                    .ErrorSignalName = "mysql.errors",
                }, readerPool)
    {
    }

    TDataPusher::~TDataPusher() {
        Stop();
    }

    void TDataPusher::AddUnistat(NUnistat::TBuilder& builder) {
        AddUnistatBase(builder);

        builder.Add(Unistat.Requests);
    }

    TDataPushWorker::TDataPushWorker(const TPusherSettings& settings, size_t idx, TDataPusher& parent)
        : TBase(settings.Base, idx, parent, [this](auto& d) { return Proc(d); })
        , Db_(*settings.Db)
    {
        TLog::Debug() << "TDataPushWorker was created: " << idx;
        Y_VERIFY(settings.Db);
    }

    bool TDataPushWorker::Proc(TLbReaderPool::TParsedData& data) {
        std::vector<TString> queries = data.Data.BuildSql();

        for (const TString& query : queries) {
            NDbPool::TBlockingHandle h(Db_);

            h.Query(query);

            ++GetParent().Unistat.Requests;
        }

        TLog::Debug() << "DataPushWorker: succeed to write " << data.Data.size()
                      << " entities, cookies " << JoinSeq(",", data.Traceids);

        for (NThreading::TPromise<void>& p : data.Promises) {
            p.SetValue();
        }

        return true;
    }
}
