#pragma once

#include "processor.h"

#include <passport/infra/libs/cpp/logbroker/processing/reader_pool.h>
#include <passport/infra/libs/cpp/logbroker/pusher/base_pusher.h>

namespace NPassport::NDbPool {
    class TDbPool;
}

namespace NPassport::NLbcPharma {
    using TLbReaderPool = NLb::TReaderPool<TQueries>;
    using TLbReaderPoolPtr = NLb::TReaderPoolPtr<TQueries>;

    struct TPusherSettings {
        NDbPool::TDbPool* Db = nullptr;
        NLb::NPusher::TBaseWorkerSettings Base;
    };

    class TDataPusher: public NLb::NPusher::TBasePusher<TDataPusher, TQueries> {
        using TBase = NLb::NPusher::TBasePusher<TDataPusher, TQueries>;

    public:
        TDataPusher(TLbReaderPoolPtr readerPool);
        ~TDataPusher();

        void AddUnistat(NUnistat::TBuilder& builder);

    public:
        struct TUnistat {
            NUnistat::TSignalDiff<> Requests = {"mysql.requests"};
        } Unistat;
    };

    class TDataPushWorker: public NLb::NPusher::TBaseWorker<TDataPusher> {
        using TBase = NLb::NPusher::TBaseWorker<TDataPusher>;

    public:
        TDataPushWorker(const TPusherSettings& settings, size_t idx, TDataPusher& parent);

        bool Proc(TLbReaderPool::TParsedData& data);

    private:
        NDbPool::TDbPool& Db_;
    };

    using TDataPusherPtr = std::unique_ptr<TDataPusher>;
}
