#pragma once

#include "cleaner.h"
#include "data_pusher.h"

#include <passport/infra/libs/cpp/dbpool/db_pool_ctx.h>
#include <passport/infra/libs/cpp/request/request.h>

#include <library/cpp/tvmauth/client/facade.h>

#include <memory>
#include <vector>

namespace NPassport::NJson {
    class TConfig;
}

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NLbcPharma {
    class TLbcPharma {
    public:
        TLbcPharma();
        ~TLbcPharma();

        void Init(const NJson::TConfig& config);

        void HandleRequest(NCommon::TRequest& req);

        void AddUnistat(NUnistat::TBuilder& builder);

    private:
        using TLogTypes = std::vector<TString>;

        void InitTvm(const NJson::TConfig& config, const TString& path);
        TLogTypes InitLogbroker(const NJson::TConfig& config, const TString& path);
        void InitDb(const NJson::TConfig& config, const TString& path);
        void InitDataPusher(const NJson::TConfig& config, const TString& path);
        void InitProcessor(const NJson::TConfig& config, const TString& path, TLogTypes&& logTypes);
        void InitCleaner(const NJson::TConfig& config, const TString& path);

        void HandleHealthCheck(NCommon::TRequest& req);

        void Start();
        void Stop();

    private:
        TDataPusherPtr DataPusher_;
        TLbReaderPoolPtr Lb_;
        std::shared_ptr<NLb::TResourceDispatcher> UncommittedMemoryDispatcher_;
        std::shared_ptr<NTvmAuth::TTvmClient> Tvm_;
        TProcessorPtr Processor_;
        TCleanerPtr Cleaner_;

        std::shared_ptr<NDbPool::TDbPoolCtx> DbCtx_;
        std::shared_ptr<NDbPool::TDbPool> Db_;
    };
}
