#pragma once

#include <passport/infra/libs/cpp/utils/ipaddr.h>

#include <optional>

namespace NPassport::NLbcPharma::NParser {
    struct TBaseRow {
        ui64 Phonenum = 0;
        std::optional<NUtils::TIpAddr> UserIp;
        TString UserAgent;
        time_t Ts = 0;

        bool operator==(const TBaseRow& o) const {
            return Phonenum == o.Phonenum &&
                   UserIp == o.UserIp &&
                   UserAgent == o.UserAgent &&
                   Ts == o.Ts;
        }
    };
}
