#include "bindings.h"

#include <passport/infra/daemons/lbcpharma/src/processor.h>

namespace NPassport::NLbcPharma::NParser {
    TBindingsParser::TBindingsParser(NUtils::ILogger* logger)
        : TParserWithBadLineLog(TLogTypeTraits{}, ELogType::Bindings, logger)
    {
    }

    TBindingsParser::TResult TBindingsParser::Parse(const NLb::TTopicData& data) {
        ReserveForTopic(data);
        ParseRows(data);
        return std::move(Result_);
    }

    bool TBindingsParser::ParseRow(TStringBuf line) {
        Tskv_.Reset(line);

        TStringBuf format = Tskv_.GetField("tskv_format");
        Y_ENSURE(format == "pharma",
                 "format '" << format << "' is unknown, supported: pharma");

        TStringBuf action = Tskv_.GetField("action");
        Y_ENSURE(action == "confirmed",
                 "action '" << action << "' is unknown, supported: confirmed");

        TBindingsRow row;
        row.UserIp = Tskv_.GetOptionalIp("user_ip");
        row.UserAgent = TString(Tskv_.GetOptionalField("user_agent"));

        Tskv_.GetNum("phonenumber", row.Phonenum);
        Tskv_.GetNum("ts", row.Ts);
        Tskv_.GetNum("uid", row.Uid);

        Result_.push_back(std::move(row));
        return true;
    }

    void TBindingsParser::Reserve(size_t size) {
        Result_.reserve(size);
    }
}
