#pragma once

#include "base_row.h"

#include <passport/infra/libs/cpp/logbroker/processing/base_parser.h>
#include <passport/infra/libs/cpp/logbroker/row_parsers/tskv_row.h>

namespace NPassport::NLbcPharma::NParser {
    struct TBindingsRow: TBaseRow {
        ui64 Uid = 0;

        bool operator==(const TBindingsRow& o) const {
            return Uid == o.Uid &&
                   TBaseRow::operator==(o);
        }
    };

    class TBindingsParser: public NLb::TParserWithBadLineLog {
    public:
        using TResult = std::vector<TBindingsRow>;

        TBindingsParser(NUtils::ILogger* logger = nullptr);

        TResult Parse(const NLb::TTopicData& data);

    protected:
        bool ParseRow(TStringBuf line) override;
        void Reserve(size_t size) override;

    private:
        TResult Result_;
        NRowParsers::TTskvRow Tskv_;
    };
}
