#include "yasms_private.h"

#include <passport/infra/daemons/lbcpharma/src/processor.h>

#include <library/cpp/string_utils/tskv_format/tskv_map.h>

namespace NPassport::NLbcPharma::NParser {
    TYasmsPrivateParser::TYasmsPrivateParser(NUtils::ILogger* logger)
        : TParserWithBadLineLog(TLogTypeTraits{}, ELogType::YasmsPrivate, logger)
    {
    }

    TYasmsPrivateParser::TResult TYasmsPrivateParser::Parse(const NLb::TTopicData& data) {
        ReserveForTopic(data);
        ParseRows(data);
        return std::move(Result_);
    }

    bool TYasmsPrivateParser::ParseRow(TStringBuf line) {
        Tskv_.Reset(line);

        if (Tskv_.GetOptionalField("action") != "enqueued") {
            return false;
        }

        TYasmsPrivateRow row;
        row.UserIp = GetUserIp(Tskv_);
        row.UserAgent = GetUserAgent(Tskv_);
        row.Ts = GetUnixtime(Tskv_);

        TStringBuf number = Tskv_.GetField("number");
        number.SkipPrefix("+");

        if (!TryIntFromString<10>(number, row.Phonenum)) {
            TLog::Warning() << "invalid 'number': '" << number << "'";
            return false;
        }

        Result_.push_back(std::move(row));
        return true;
    }

    void TYasmsPrivateParser::Reserve(size_t size) {
        Result_.reserve(size);
    }
}
