#pragma once

#include "base_row.h"

#include <passport/infra/libs/cpp/logbroker/entity_parsers/yasms_private.h>
#include <passport/infra/libs/cpp/logbroker/processing/base_parser.h>
#include <passport/infra/libs/cpp/logbroker/row_parsers/tskv_row.h>

namespace NPassport::NLbcPharma::NParser {
    struct TYasmsPrivateRow: TBaseRow {
    };

    class TYasmsPrivateParser: public NLb::TParserWithBadLineLog,
                               public NEntityParsers::TYasmsPrivateBaseParser {
    public:
        using TResult = std::vector<TYasmsPrivateRow>;

        TYasmsPrivateParser(NUtils::ILogger* logger = nullptr);

        TResult Parse(const NLb::TTopicData& data);

    protected:
        bool ParseRow(TStringBuf line) override;
        void Reserve(size_t size) override;

    private:
        TResult Result_;

        // allocated memory
        NRowParsers::TTskvRow Tskv_;
    };
}
