#pragma once

#include "query.h"

#include <passport/infra/libs/cpp/logbroker/processing/processor.h>
#include <passport/infra/libs/cpp/logbroker/processing/reader_pool.h>
#include <passport/infra/libs/cpp/unistat/time_stat.h>
#include <passport/infra/libs/cpp/utils/log/logger.h>

namespace NPassport::NDbPool {
    class TDbPool;
}

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NLbcPharma {
    enum class ELogType {
        Bindings,
        YasmsPrivate,

        COUNT,
    };

    struct TLogTypeTraits {
        using TType = ELogType;

        static const size_t count_ = (size_t)ELogType::COUNT;

        static const TString& ToString(ELogType type);
        static ELogType FromString(const TStringBuf type);
    };

    struct TProcessorSettings {
        size_t BatchSize = 100;
    };

    class TProcessor: NLb::TBaseProcessor<TLogTypeTraits> {
        using TBase = NLb::TBaseProcessor<TLogTypeTraits>;

    public:
        TProcessor(const TProcessorSettings& settings,
                   NDbPool::TDbPool& db,
                   NLb::TBadLineLoggers<TLogTypeTraits> badLinesLoggers);
        ~TProcessor();

        void AddUnistat(NUnistat::TBuilder& builder) const;

        TQueries Proc(const NLb::TDataSet<>& data);

    private:
        TQueries ChooseProc(const NLb::TTopicData& td);
        TQueries ProcBindings(const NLb::TTopicData& data);
        TQueries ProcYasmsPrivate(const NLb::TTopicData& data);

    private:
        const TProcessorSettings Settings_;

        NUnistat::TTimeStat UnistatBindingsReadLag_;
        NUnistat::TTimeStat UnistatYasmsPrivateReadLag_;

        NDbPool::TDbPool& Db_;
    };

    using TProcessorPtr = std::unique_ptr<TProcessor>;
}
