#pragma once

#include <util/generic/string.h>

#include <vector>

namespace NPassport::NLbcPharma {
    struct TQuery {
        TString SerializedEntity;
    };

    class IQueryBuilder {
    public:
        virtual ~IQueryBuilder() = default;
        virtual TString Build(const std::vector<TQuery>& q) const = 0;
    };
    using TQueryBuilderPtr = std::shared_ptr<IQueryBuilder>;

    class TQueries {
    public:
        using TBatches = std::vector<std::vector<TQuery>>;

        struct TPerTable {
            TString TableName;
            TQueryBuilderPtr Builder;
            TBatches Batches;
        };

    public:
        TQueries(size_t batchSize = 0)
            : BatchSize_(batchSize)
        {
        }

        void Reserve(const TString& tableName, const TQueryBuilderPtr& builder, size_t size);
        void Add(const TString& tableName, const TQueryBuilderPtr& builder, TQuery&& query);

        void Merge(TQueries&& queries);

        std::vector<TString> BuildSql() const;
        size_t size() const;

    private:
        TBatches& MutateBatches(const TString& tableName, const TQueryBuilderPtr& builder);

    private:
        std::vector<TPerTable> Data_;
        size_t BatchSize_ = 0;
        size_t Size_ = 0;
    };

    class TBaseQueryBuilder: public IQueryBuilder {
    protected:
        static TString BuildImpl(const std::vector<TQuery>& queries,
                                 TStringBuf header,
                                 TStringBuf footer);
    };
}
