#pragma once

#include <passport/infra/libs/cpp/dbpool/db_pool.h>
#include <passport/infra/libs/cpp/dbpool/handle.h>

#include <util/stream/file.h>

namespace NPassport {
    static NDbPool::TDbPool CreatePool(TString sqlFile = "") {
        if (sqlFile.empty()) {
            sqlFile = "empty.sql";
            TFileOutput f(sqlFile);
        }

        return NDbPool::TDbPool(NDbPool::TDbPoolSettings{
            .Dsn = NDbPool::TDestination::CreateSqlite(sqlFile),
        });
    }
}
