#include <passport/infra/daemons/lbcpharma/ut/common.h>

#include <passport/infra/daemons/lbcpharma/src/converters/bindings.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NLbcPharma;
using namespace NPassport::NLbcPharma::NParser;
using namespace NPassport::NLbcPharma::NConverter;

Y_UNIT_TEST_SUITE(BindingsConverter) {
    Y_UNIT_TEST(serializeEntity) {
        NDbPool::TDbPool db = CreatePool();
        NDbPool::TBlockingHandle h(db);

        TBindingsConverter conv(h);

        UNIT_ASSERT_VALUES_EQUAL(
            "(0,0,'','',4294967295)",
            conv.SerializeEntity(TBindingsRow{}));

        UNIT_ASSERT_VALUES_EQUAL(
            "(123,0,'','',4294966839)",
            conv.SerializeEntity(TBindingsRow{TBaseRow{
                .Phonenum = 123,
                .Ts = 456,
            }}));
        UNIT_ASSERT_VALUES_EQUAL(
            "(123,0,'127.0.0.2','',4294966839)",
            conv.SerializeEntity(TBindingsRow{TBaseRow{
                .Phonenum = 123,
                .UserIp = NUtils::TIpAddr("127.0.0.2"),
                .Ts = 456,
            }}));
        UNIT_ASSERT_VALUES_EQUAL(
            "(123,0,'127.0.0.2','''); SELECT uid, type, value FROM attributes; (''',4294966839)",
            conv.SerializeEntity(TBindingsRow{TBaseRow{
                .Phonenum = 123,
                .UserIp = NUtils::TIpAddr("127.0.0.2"),
                .UserAgent = "'); SELECT uid, type, value FROM attributes; ('",
                .Ts = 456,
            }}));
    }

    Y_UNIT_TEST(process) {
        NDbPool::TDbPool db = CreatePool();
        NDbPool::TBlockingHandle h(db);

        TBindingsConverter conv(h);

        TBindingsRow row;
        conv.Process(TBindingsRow{row});

        row.Phonenum = 123;
        row.Ts = 456;
        row.Uid = 789;
        conv.Process(TBindingsRow{row});

        row.UserIp = NUtils::TIpAddr("127.0.0.2");
        conv.Process(TBindingsRow{row});

        row.UserAgent = "some user agent кек";
        conv.Process(TBindingsRow{row});

        TQueries queries = conv.Finish();

        UNIT_ASSERT_VALUES_EQUAL(
            std::vector<TString>({
                "INSERT INTO bindings(phonenum, uid, ip, ua, add_ts) VALUES "
                "(0,0,'','',4294967295),"
                "(123,789,'','',4294966839),"
                "(123,789,'127.0.0.2','',4294966839),"
                "(123,789,'127.0.0.2','some user agent \xD0\xBA\xD0\xB5\xD0\xBA',4294966839)"
                " ON DUPLICATE KEY UPDATE phonenum=phonenum",
            }),
            queries.BuildSql());
        UNIT_ASSERT_VALUES_EQUAL(4, queries.size());
    }
}
