#include <passport/infra/daemons/lbcpharma/ut/common.h>

#include <passport/infra/daemons/lbcpharma/src/converters/yasms_private.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NLbcPharma;
using namespace NPassport::NLbcPharma::NParser;
using namespace NPassport::NLbcPharma::NConverter;

Y_UNIT_TEST_SUITE(YasmsPrivateConverter) {
    Y_UNIT_TEST(serializeEntity) {
        NDbPool::TDbPool db = CreatePool();
        NDbPool::TBlockingHandle h(db);

        TYasmsPrivateConverter conv(h);

        UNIT_ASSERT_VALUES_EQUAL(
            "(0,'','',4294967295)",
            conv.SerializeEntity(TYasmsPrivateRow{}));

        UNIT_ASSERT_VALUES_EQUAL(
            "(123,'','',4294966839)",
            conv.SerializeEntity(TYasmsPrivateRow{TBaseRow{
                .Phonenum = 123,
                .Ts = 456,
            }}));
        UNIT_ASSERT_VALUES_EQUAL(
            "(123,'127.0.0.2','',4294966839)",
            conv.SerializeEntity(TYasmsPrivateRow{TBaseRow{
                .Phonenum = 123,
                .UserIp = NUtils::TIpAddr("127.0.0.2"),
                .Ts = 456,
            }}));
        UNIT_ASSERT_VALUES_EQUAL(
            "(123,'127.0.0.2','''); SELECT uid, type, value FROM attributes; (''',4294966839)",
            conv.SerializeEntity(TYasmsPrivateRow{TBaseRow{
                .Phonenum = 123,
                .UserIp = NUtils::TIpAddr("127.0.0.2"),
                .UserAgent = "'); SELECT uid, type, value FROM attributes; ('",
                .Ts = 456,
            }}));
    }

    Y_UNIT_TEST(process) {
        NDbPool::TDbPool db = CreatePool();
        NDbPool::TBlockingHandle h(db);

        TYasmsPrivateConverter conv(h);

        conv.Process(TYasmsPrivateRow{});
        conv.Process(TYasmsPrivateRow{TBaseRow{
            .Phonenum = 123,
            .Ts = 456,
        }});
        conv.Process(TYasmsPrivateRow{TBaseRow{
            .Phonenum = 123,
            .UserIp = NUtils::TIpAddr("127.0.0.2"),
            .Ts = 456,
        }});
        conv.Process(TYasmsPrivateRow{TBaseRow{
            .Phonenum = 123,
            .UserIp = NUtils::TIpAddr("127.0.0.2"),
            .UserAgent = "some user agent кек",
            .Ts = 456,
        }});

        TQueries queries = conv.Finish();

        UNIT_ASSERT_VALUES_EQUAL(
            std::vector<TString>({
                "INSERT INTO usages(phonenum, ip, ua, ts) VALUES "
                "(0,'','',4294967295),"
                "(123,'','',4294966839),"
                "(123,'127.0.0.2','',4294966839),"
                "(123,'127.0.0.2','some user agent \xD0\xBA\xD0\xB5\xD0\xBA',4294966839)"
                " ON DUPLICATE KEY UPDATE phonenum=phonenum",
            }),
            queries.BuildSql());
        UNIT_ASSERT_VALUES_EQUAL(4, queries.size());
    }
}
