#include <passport/infra/daemons/lbcpharma/src/parsers/yasms_private.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NLbcPharma;
using namespace NPassport::NLbcPharma::NParser;

Y_UNIT_TEST_SUITE(YasmsPrivateParser) {
    class TTestSmsParser: public NParser::TYasmsPrivateParser {
    public:
        using TYasmsPrivateParser::ParseRow;
    };

    Y_UNIT_TEST(parse) {
        TTestSmsParser parser;

        UNIT_ASSERT_EXCEPTION_CONTAINS(parser.ParseRow(""),
                                       yexception,
                                       "line should start with 'tskv'");
        UNIT_ASSERT(!parser.ParseRow("tskv\t"
                                     "tskv_format=something"));
        UNIT_ASSERT(!parser.ParseRow("tskv\t"
                                     "tskv_format=something\t"
                                     "action=kek"));

        UNIT_ASSERT_EXCEPTION_CONTAINS(parser.ParseRow("tskv\t"
                                                       "action=enqueued"),
                                       yexception,
                                       "no field 'unixtime'");

        UNIT_ASSERT_EXCEPTION_CONTAINS(parser.ParseRow("tskv\t"
                                                       "action=enqueued\t"
                                                       "unixtime=100500"),
                                       yexception,
                                       "no field 'number'");
        UNIT_ASSERT(!parser.ParseRow("tskv\t"
                                     "action=enqueued\t"
                                     "unixtime=100500\t"
                                     "number=asd"));
        UNIT_ASSERT_NO_EXCEPTION(parser.ParseRow("tskv\t"
                                                 "action=enqueued\t"
                                                 "unixtime=100500\t"
                                                 "number=456"));
        UNIT_ASSERT_NO_EXCEPTION(parser.ParseRow("tskv\t"
                                                 "action=enqueued\t"
                                                 "unixtime=100500\t"
                                                 "number=+456"));

        UNIT_ASSERT_EXCEPTION_CONTAINS(parser.ParseRow("tskv\t"
                                                       "action=enqueued\t"
                                                       "unixtime=100500\t"
                                                       "number=+456\t"
                                                       "user_ip=kek"),
                                       yexception,
                                       "invalid ip address in 'user_ip': 'kek'");
        UNIT_ASSERT_NO_EXCEPTION(parser.ParseRow("tskv\t"
                                                 "action=enqueued\t"
                                                 "unixtime=100500\t"
                                                 "number=+789\t"
                                                 "user_ip=123.0.0.1\t"
                                                 "user_agent=asdas"));

        TYasmsPrivateParser::TResult result = parser.Parse({});
        UNIT_ASSERT_VALUES_EQUAL(
            result,
            TYasmsPrivateParser::TResult({
                TYasmsPrivateRow{TBaseRow{
                    .Phonenum = 456,
                    .Ts = 100500,
                }},
                TYasmsPrivateRow{TBaseRow{
                    .Phonenum = 456,
                    .Ts = 100500,
                }},
                TYasmsPrivateRow{TBaseRow{
                    .Phonenum = 789,
                    .UserIp = NUtils::TIpAddr("123.0.0.1"),
                    .UserAgent = "asdas",
                    .Ts = 100500,
                }},
            }));
    }
}

template <>
void Out<TYasmsPrivateRow>(IOutputStream& o, const TYasmsPrivateRow& value) {
    o << "num=" << value.Phonenum << ";";
    o << "ip=" << (value.UserIp ? value.UserIp->ToString() : TString()) << ";";
    o << "agent=" << value.UserAgent << ";";
    o << "ts=" << value.Ts << ";";
}

template <>
void Out<TYasmsPrivateParser::TResult>(IOutputStream& o, const TYasmsPrivateParser::TResult& value) {
    for (const auto& r : value) {
        o << r << Endl;
    }
}
