#include <passport/infra/daemons/lbcpharma/src/query.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NLbcPharma;

Y_UNIT_TEST_SUITE(Query) {
    class TTestQueryBuilder: public TBaseQueryBuilder {
    public:
        TTestQueryBuilder(TString table)
            : Table(table)
        {
        }

        TString Build(const std::vector<TQuery>& q) const override {
            return BuildImpl(q, "INSERT INTO " + Table + " VALUES ", "");
        }

        static TQueryBuilderPtr Create(TString table = "foo") {
            return std::make_shared<TTestQueryBuilder>(table);
        }

        TString Table;
    };

    Y_UNIT_TEST(reserve) {
        TQueries queries;

        queries.Reserve("kek", TTestQueryBuilder::Create(), 100);

        UNIT_ASSERT_VALUES_EQUAL(
            std::vector<TString>({}),
            queries.BuildSql());
        UNIT_ASSERT_VALUES_EQUAL(0, queries.size());
    }

    Y_UNIT_TEST(add) {
        TQueries queries;

        queries.Add("kek", TTestQueryBuilder::Create("kek"), {"(some entry)"});
        queries.Add("kek", TTestQueryBuilder::Create("kek"), {"(some other entry)"});
        queries.Add("lol", TTestQueryBuilder::Create("lol"), {"(yet another entry)"});

        UNIT_ASSERT_VALUES_EQUAL(
            std::vector<TString>({
                "INSERT INTO kek VALUES (some entry),(some other entry)",
                "INSERT INTO lol VALUES (yet another entry)",
            }),
            queries.BuildSql());
        UNIT_ASSERT_VALUES_EQUAL(3, queries.size());
    }

    Y_UNIT_TEST(addWithBatchSize) {
        TQueries queries(2);

        for (size_t idx = 0; idx < 5; ++idx) {
            queries.Add("kek",
                        TTestQueryBuilder::Create("kek"),
                        {TStringBuilder() << "(some entry #" << idx << ")"});
        }
        queries.Add("lol", TTestQueryBuilder::Create("lol"), {"(yet another entry)"});

        UNIT_ASSERT_VALUES_EQUAL(
            std::vector<TString>({
                "INSERT INTO kek VALUES (some entry #0),(some entry #1)",
                "INSERT INTO kek VALUES (some entry #2),(some entry #3)",
                "INSERT INTO kek VALUES (some entry #4)",
                "INSERT INTO lol VALUES (yet another entry)",
            }),
            queries.BuildSql());
        UNIT_ASSERT_VALUES_EQUAL(6, queries.size());
    }

    Y_UNIT_TEST(merge) {
        TQueries queries1;
        for (size_t idx = 0; idx < 3; ++idx) {
            queries1.Add("kek",
                         TTestQueryBuilder::Create("kek"),
                         {TStringBuilder() << "(some entry #" << idx << ")"});
        }
        UNIT_ASSERT_VALUES_EQUAL(
            std::vector<TString>({
                "INSERT INTO kek VALUES (some entry #0),(some entry #1),(some entry #2)",
            }),
            queries1.BuildSql());
        UNIT_ASSERT_VALUES_EQUAL(3, queries1.size());

        TQueries queries2;
        queries2.Add("lol", TTestQueryBuilder::Create("lol"), {"(yet another entry)"});
        UNIT_ASSERT_VALUES_EQUAL(
            std::vector<TString>({
                "INSERT INTO lol VALUES (yet another entry)",
            }),
            queries2.BuildSql());
        UNIT_ASSERT_VALUES_EQUAL(1, queries2.size());

        TQueries queries3;
        for (size_t idx = 3; idx < 5; ++idx) {
            queries3.Add("kek",
                         TTestQueryBuilder::Create("kek"),
                         {TStringBuilder() << "(some entry #" << idx << ")"});
        }
        UNIT_ASSERT_VALUES_EQUAL(
            std::vector<TString>({
                "INSERT INTO kek VALUES (some entry #3),(some entry #4)",
            }),
            queries3.BuildSql());
        UNIT_ASSERT_VALUES_EQUAL(2, queries3.size());

        TQueries q(2);
        q.Merge(std::move(queries1));
        q.Merge(std::move(queries2));
        q.Merge(std::move(queries3));

        UNIT_ASSERT_VALUES_EQUAL(
            std::vector<TString>({
                "INSERT INTO kek VALUES (some entry #0),(some entry #1)",
                "INSERT INTO kek VALUES (some entry #2),(some entry #3)",
                "INSERT INTO kek VALUES (some entry #4)",
                "INSERT INTO lol VALUES (yet another entry)",
            }),
            q.BuildSql());
        UNIT_ASSERT_VALUES_EQUAL(6, q.size());
    }
}
