import json
import sys
import re


DEFAULT_SETTINGS = {
    "API_HOSTS": {
        "logstore-f1.passport.yandex.net": 2028826,
        "kvs-logstore-f1.passport.yandex.net": 2028826,
        "mon-logstore-f1.passport.yandex.net": 2028826,
        "logstore-s1.passport.yandex.net": 2028826,
    },
    "API_PORT": 443,
    "USE_TLS": True,
    "SKIP_ENVS": [
        "development",
        "stress",
        "load",
    ],
    "OVERRIDE_API_HOST": "",
}


SETTINGS = {
    "*": {
        "SELF_TVM_ID": 2030187,
        "API_HOSTS": {
            "localhost": 2028824,
        },
        "API_PORT": 10087,
        "USE_TLS": False,
    },
    "development": {
        "SELF_TVM_ID": 2030187,
        "API_HOSTS": {
            "localhost": 2028824,
        },
        "API_PORT": 10087,
        "USE_TLS": False,
        "SKIP_ENVS": [
            "development",  # remove this to enable logs transferring on dev
            "stress",
            "load",
            "testing",
            "rc",
            "production",
        ],
        "OVERRIDE_API_HOST": "localhost",
    },
    "testing": {
        "SELF_TVM_ID": 2030189,
    },
    "testing-beta": {
        "SELF_TVM_ID": 2030189,
    },
    "testing-intranet": {
        "SELF_TVM_ID": 2030191,
    },
    "production": {
        "SELF_TVM_ID": 2030195,
    },
    "production-intranet": {
        "SELF_TVM_ID": 2030193,
    },
    "production-other": {
        "SELF_TVM_ID": 2030195,
    },
    "rc": {
        "SELF_TVM_ID": 2030197,
    },
    "rc-intranet": {
        "SELF_TVM_ID": 2030199,
    },
}


def do(template, env_type, env_name, host_name):
    env = '%s-%s' % (env_type, env_name) if env_name != 'localhost' else env_type

    if env not in SETTINGS and not re.match(r'^.*(development|stress|load).*$', env):
        raise Exception("env '%s' is unknown" % env)

    setts = SETTINGS[env] if env in SETTINGS else SETTINGS['*']
    setts['ENV'] = env
    setts['HOST_NAME'] = host_name
    for key, value in DEFAULT_SETTINGS.items():
        if key not in setts:
            setts[key] = value

    for key, value in setts.items():
        template = template.replace('<<%s>>' % key, json.dumps(value))

    if '<<' in template or '>>' in template:
        raise Exception("some options were not specified: %s\n" % template)

    print(template)


if __name__ == '__main__':
    if len(sys.argv) != 5:
        print("Usage: %s <template_file> <env_type> <env_name> <host_name>" % (sys.argv[0]))
        sys.exit(1)

    with open(sys.argv[1]) as f:
        template = f.read()
        assert len(template) > 0

    do(template, sys.argv[2], sys.argv[3], sys.argv[4])
