#pragma once

#include <util/datetime/base.h>
#include <util/folder/path.h>
#include <util/generic/string.h>

namespace NPassport::NLogstoreAgent {
    struct TCommonConfig {
        enum class ECompressionCodec {
            PlainText = 0,
            GZip = 1,
            ZStd0 = 2,
            ZStd3 = 3,
            ZStd5 = 4,
        };

        enum class ETimeAggregation {
            Day,
            Hour,
        };

        TString Env;
        size_t ChunkSize = 0;
        TDuration ChunkCollectTimeout;
        ECompressionCodec CompressionCodec = ECompressionCodec::PlainText;
        size_t ParallelPushesPerLog = 0;
        ETimeAggregation Aggregation = ETimeAggregation::Day;

        TDuration RotationTimeout = TDuration::Minutes(1);
        TDuration ForceRotationTimeout = TDuration::Minutes(2);

        size_t MaxHistorySize = 1440;
        TDuration HistoryUpdatePeriod = TDuration::Minutes(1);
        TDuration ReadLagWarningThreshold = TDuration::Minutes(120);
        TDuration ReadLagCriticalThreshold = TDuration::Minutes(240);
    };

    struct TInstanceConfig {
        TFsPath Filename;
        // TODO: Make class to hold, parse, verify this
        TString DestinationHost;

        TCommonConfig Common;
    };
}
