#pragma once

#include "instance_config.h"
#include "log_stream_config.h"

#include <util/generic/string.h>

#include <unordered_map>
#include <vector>

namespace NTvmAuth {
    class TTvmClient;
}

namespace NPassport::NDbPool {
    class TDbPool;
    class TDbPoolCtx;
}

namespace NPassport::NJson {
    class TConfig;
}

namespace NPassport::NLogstoreAgent {
    struct TContext {
        using TConfigByHostnameMap = std::unordered_map<TString, TLogStreamConfig>;
        using TConfigsByFilenameMap = std::unordered_map<TString, TConfigByHostnameMap>;

        std::shared_ptr<NDbPool::TDbPoolCtx> Ctx;
        TConfigsByFilenameMap Configs;
    };

    class TRuntimeContext {
    public:
        TRuntimeContext(const NJson::TConfig& config, const TString& jpoint);
        ~TRuntimeContext();

        static void InitLogger(const TString& filename);

        std::shared_ptr<NTvmAuth::TTvmClient> Tvm() const {
            return Tvm_;
        }

        TContext PrepareContext() const;
        bool CheckContext(std::shared_ptr<TContext> context) const;
        TDuration GetFilesRescanPeriod() const;

    private:
        struct TDbSettings {
            TDuration GetTimeout;
            TDuration ConnectTimeout;
            TDuration QueryTimeout;
            bool UseTls = false;
            ui16 Port = 0;
        };

    private:
        void InitDefaultSettings(const NJson::TConfig& config, const TString& jpoint);
        void InitDbSettings(const NJson::TConfig& config, const TString& jpoint);
        void InitInstances(const NJson::TConfig& config, const TString& jpoint);
        void InitTvm(const NJson::TConfig& config, const TString& jpoint);

        static std::vector<TString> GetFilenamesWithInstances(const TString& dir);
        std::vector<TInstanceConfig> ReadInstances(const TString& filepath) const;

        std::shared_ptr<NDbPool::TDbPool> CreatePool(
            std::shared_ptr<NDbPool::TDbPoolCtx> ctx,
            const TString& destinationHost,
            size_t size) const;

    private:
        TString DbPoolLogFile_;

        TCommonConfig DefaultSettings_;
        TString OverrideDestinationHost_;
        TString Hostname_;
        TFsPath CacheDir_;
        TDuration FilesRescanPeriod_ = TDuration::Minutes(1);
        TDbSettings DbSettings_;
        std::vector<TInstanceConfig> Instances_;
        std::shared_ptr<NTvmAuth::TTvmClient> Tvm_;
    };
}
