#pragma once

#include <passport/infra/daemons/logstoreagent/src/cfg/instance_config.h>
#include <passport/infra/daemons/logstoreagent/src/utils/task.h>

#include <passport/infra/libs/cpp/tail/reader.h>

#include <util/system/event.h>

#include <functional>

namespace NPassport::NJuggler {
    class TStatus;
}

namespace NPassport::NLogstoreAgent {
    using TChunk = NTail::TBuffer;
    using TChunkPtr = std::shared_ptr<NTail::TBuffer>;
    using TTailerCallback = std::function<bool(TChunkPtr)>;

    // TODO: move to configs to make it directly constructable from json
    struct TTailerSettings {
        TFsPath Filename;

        TString TailerId;

        std::shared_ptr<TTailerCallback> Callback;
        size_t Offset = 0;
        size_t INode = 0;

        size_t ChunkSize = 0;

        TDuration RotationTimeout;
        TDuration ForceRotationTimeout;

        TFsPath CacheDir;

        size_t MaxHistorySize = 0;
        TDuration HistoryUpdatePeriod;
        TDuration ReadLagWarningThreshold;
        TDuration ReadLagCriticalThreshold;
    };

    class TTailer {
    public:
        explicit TTailer(TTailerSettings&& settings);

        virtual ~TTailer() = default;

        ETaskStatus Run();

        NJuggler::TStatus GetJugglerStatus() const;

    private:
        void InitReader(const TTailerSettings& settings);

    private:
        std::shared_ptr<TTailerCallback> Callback_;
        std::unique_ptr<NTail::TReader> Reader_;

        const TString TailerId_;

        const size_t BufferLimit_;
        TChunkPtr NextChunk_;

        const TDuration ReadLagWarningThreshold_;
        const TDuration ReadLagCriticalThreshold_;
    };
}
