#pragma once

#include "input/tailer.h"
#include "utils/task.h"

#include <passport/infra/daemons/logstoreagent/src/cfg/log_stream_config.h>

#include <passport/infra/libs/cpp/unistat/diff.h>
#include <passport/infra/libs/cpp/unistat/name_factory.h>
#include <passport/infra/libs/cpp/utils/regular_task.h>
#include <passport/infra/libs/cpp/utils/shared_state.h>

#include <shared_mutex>

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NJuggler {
    class TStatus;
}

namespace NPassport::NDbPool {
    class TDbPool;
}

namespace NPassport::NLogstoreAgent {
    class TTailer;
    class TScheduler;

    class IStateHolder;
    class TCompressionProcessor;

    using TTailerTask = TTaskDecorator<TTailer>;
    using TSchedulerTask = TTaskDecorator<TScheduler>;

    class TLogStream {
    public:
        explicit TLogStream(const TLogStreamConfig& config, const NUnistat::TNameFactory::TTags& unistatTags);
        ~TLogStream();

        NJuggler::TStatus GetJugglerStatus() const;

        void AddUnistat(NUnistat::TBuilder& builder);

    private:
        void Start();
        void InitInput();
        void InitScheduler();

        void DestroyState();

        void InitUnistat();

        bool ProcessChunk(TChunkPtr chunk);

    private:
        const TLogStreamConfig Settings_;
        const NUnistat::TNameFactory::TTags UnistatTags_;

        std::unique_ptr<NUnistat::TSignalDiff<ui64>> SignalTotalBytes_;
        std::unique_ptr<NUnistat::TSignalDiff<ui64>> SignalTotalChunks_;

        mutable std::shared_mutex ReinitializationLock_;

        std::unique_ptr<TSchedulerTask> Scheduler_;
        std::unique_ptr<TTailerTask> Tailer_;

        std::thread Thread_;

        NUtils::TSharedState<TString> LastError_;
        std::atomic_bool Shutdown_;
    };
}
