#pragma once
#include "log_stream.h"

#include <passport/infra/libs/cpp/utils/shared_state.h>

#include <memory>
#include <shared_mutex>
#include <vector>

namespace NPassport::NUtils {
    class TRegularTask;
}

namespace NPassport::NJuggler {
    class TStatus;
}

namespace NPassport::NLogstoreAgent {
    class TLogStream;
    class TRuntimeContext;

    struct TContext;

    using TLogStreamPtr = std::unique_ptr<TLogStream>;

    class TLogStreamManager {
    public:
        explicit TLogStreamManager(std::shared_ptr<TRuntimeContext> context);

        ~TLogStreamManager();

        void AddUnistat(NUnistat::TBuilder& builder);

        NJuggler::TStatus GetJugglerStatus();

    private:
        void InitStreams();
        void InitTask();

        std::shared_ptr<TRuntimeContext> Runtime_;
        NUtils::TSharedState<TContext> StreamContext_;
        std::vector<TLogStreamPtr> Streams_;
        std::unique_ptr<NUtils::TRegularTask> CheckRuntimeTask_;

        std::shared_mutex StreamsLock_;
    };
}
