#pragma once

#include <passport/infra/libs/cpp/request/request.h>

namespace NPassport::NJson {
    class TConfig;
}

namespace NPassport::NJuggler {
    class TStatus;
}

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NLogstoreAgent {
    class TLogStreamManager;
    class TRuntimeContext;

    class TLogstoreAgent {
    public:
        TLogstoreAgent();
        ~TLogstoreAgent();

        void Init(const NJson::TConfig& config);

        void HandleRequest(NCommon::TRequest& req);

        void AddUnistat(NUnistat::TBuilder& builder);

    private:
        void HandleHealthCheck(NCommon::TRequest& req);
        NJuggler::TStatus GetJugglerStatus();

        std::unique_ptr<TLogStreamManager> StreamManager_;
        std::shared_ptr<TRuntimeContext> Runtime_;
    };
}
