#pragma once

#include <passport/infra/daemons/logstoreagent/src/cfg/instance_config.h>

#include <passport/infra/libs/cpp/dbpool/db_pool.h>
#include <passport/infra/libs/cpp/dbpool/handle.h>

#include <util/datetime/base.h>
#include <util/generic/string.h>

#include <vector>

namespace NPassport::NLogstoreAgent {
    struct TLogstoreApiStreamSettings {
        TString ClientId;

        TString File;
        TString Host;
        TString Env;

        TCommonConfig::ECompressionCodec Codec = TCommonConfig::ECompressionCodec::PlainText;
        TCommonConfig::ETimeAggregation Aggregation = TCommonConfig::ETimeAggregation::Day;
    };

    class ILogstoreApiStream {
    public:
        struct TResult {
            size_t Completed = 0;
            size_t Accepted = 0;
            std::optional<TString> Error;
        };

        class TMissingDataException: public yexception {
        public:
            explicit TMissingDataException(size_t offset = 0);

            static TMissingDataException CreateFrom(NDbPool::THttpResponse& response);

            const size_t ExpectedOffset = 0;
        };

        virtual ~ILogstoreApiStream() = default;

        virtual void Start(TInstant createTime, size_t iNode, size_t offset) = 0;

        virtual TString PrepareChunk(const TString& chunk) const = 0;
        virtual void Push(TString&& chunk, size_t offset) = 0;
        virtual TResult Wait() = 0;

        virtual bool IsValid() const = 0;
    };

    class TLogstoreApiStream: public ILogstoreApiStream {
    public:
        explicit TLogstoreApiStream(std::shared_ptr<NDbPool::TDbPool> pool, TLogstoreApiStreamSettings&& settings = {});

        void Start(TInstant createTime, size_t iNode, size_t offset) override;
        void Stop();

        TString PrepareChunk(const TString& chunk) const override;
        void Push(TString&& chunk, size_t offset) override;
        TResult Wait() override;

        bool IsValid() const override;

    protected: // for tests
        static const TString& GetEncodingName(TCommonConfig::ECompressionCodec codec);
        static const TString& GetAggregationName(TCommonConfig::ETimeAggregation aggregation);

        NDbPool::TQuery MakeCreateRequest(TInstant createTime, const TString& streamId, size_t offset) const;
        NDbPool::TQuery MakePushRequest(TString&& chunk, const TString& streamId, size_t offset) const;

    private:
        std::shared_ptr<NDbPool::TDbPool> Pool_;

        const TLogstoreApiStreamSettings Settings_;

        const TString& Codec_;
        const TString& Aggregation_;

        std::optional<TString> StreamId_;
        std::vector<NDbPool::TNonBlockingHandle> Handles_;
    };
}
