#include "processor.h"

#include <library/cpp/streams/zstd/zstd.h>

#include <util/stream/str.h>
#include <util/stream/zlib.h>

namespace NPassport::NLogstoreAgent {
    TCompressionProcessor::TCompressionProcessor(TCommonConfig::ECompressionCodec codec)
        : Codec_(codec)
    {
    }

    TString TCompressionProcessor::Compress(const TString& data) const {
        return Compress(data, Codec_);
    }

    TString TCompressionProcessor::Compress(const TString& data, TCommonConfig::ECompressionCodec codec) {
        TString compressed;
        TStringOutput output(compressed);
        std::unique_ptr<IOutputStream> coder;

        switch (codec) {
            case TCommonConfig::ECompressionCodec::GZip:
                coder = std::make_unique<TZLibCompress>(&output);
                break;
            case TCommonConfig::ECompressionCodec::ZStd0:
                coder = std::make_unique<TZstdCompress>(&output, 0);
                break;
            case TCommonConfig::ECompressionCodec::ZStd3:
                coder = std::make_unique<TZstdCompress>(&output, 3);
                break;
            case TCommonConfig::ECompressionCodec::ZStd5:
                coder = std::make_unique<TZstdCompress>(&output, 5);
                break;
            case TCommonConfig::ECompressionCodec::PlainText:
                return data;
                break;
        }

        coder->Write(data.data(), data.size());
        coder->Finish();
        output.Finish();
        return compressed;
    }
}
