#pragma once

#include <passport/infra/daemons/logstoreagent/src/input/tailer.h>
#include <passport/infra/daemons/logstoreagent/src/utils/state_holder.h>
#include <passport/infra/daemons/logstoreagent/src/utils/task.h>

#include <passport/infra/libs/cpp/unistat/diff.h>
#include <passport/infra/libs/cpp/unistat/name_factory.h>

#include <util/datetime/base.h>
#include <util/generic/string.h>
#include <util/system/event.h>

#include <list>
#include <shared_mutex>

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NJuggler {
    class TStatus;
}

namespace NPassport::NLogstoreAgent {
    class ILogstoreApiStream;
    class TThrottledStateHolder;

    struct TChunkHolder {
        TChunkPtr Chunk;
        TInstant Timestamp;
    };

    using TChunkContainer = std::list<TChunkHolder>;

    struct TSchedulerSettings: TMoveOnly {
        TFsPath CacheDir;

        TString SchedulerId;

        size_t BufferSize = 20;
        size_t MaxQueueSize = 8;
    };

    class TScheduler {
    public:
        explicit TScheduler(std::unique_ptr<ILogstoreApiStream> httpStream,
                            TSchedulerSettings&& settings = {},
                            const NUnistat::TNameFactory::TTags& unistatTags = {});
        virtual ~TScheduler();

        bool TryPush(TChunkPtr chunk, TDuration timeout = TDuration::Max());

        ETaskStatus Run();

        IStateHolder::TState GetState();

        NJuggler::TStatus GetJugglerStatus() const;

        void AddUnistat(NUnistat::TBuilder& builder);

    private:
        void InitUnistat(const NUnistat::TNameFactory::TTags& tags);

    private:
        bool WaitBuffer(TDuration timeout = TDuration::Max());

        void CreateStream();
        bool IsStreamValid();

        void PushChunks();

        void PopulateQueueFromBuffer();

        void LogHeartbeat();

    private:
        std::unique_ptr<ILogstoreApiStream> HttpStream_;

        std::unique_ptr<TThrottledStateHolder> StateHolder_;

        std::shared_mutex BufferLock_;
        TChunkContainer Buffer_;
        TAutoEvent BufferEvent_;

        TChunkContainer Queue_;

        const TSchedulerSettings Settings_;

        TInstant LastHeartbeat_;
        size_t ChunksSent_ = 0;
        size_t ChunksTriesToSend_ = 0;

        TString SignalBufferSizeName_;
        TString SignalQueueSizeName_;

        std::atomic<TInstant> AgeOldestInQueue_;
        std::atomic<TInstant> AgeOldestInBuffer_;
    };
}
