#pragma once

#include <util/datetime/base.h>

namespace NPassport::NLogstoreAgent {
    enum class EBackoffPolicy {
        Constant,
        Linear,
        Exponential,
    };

    struct TBackoffSettings {
        EBackoffPolicy Policy = EBackoffPolicy::Constant;

        TDuration MinTimeout;
        TDuration MaxTimeout;
        TDuration Jitter;
    };

    class TBackoff {
    public:
        explicit TBackoff(TBackoffSettings settings = {});

        ~TBackoff() = default;

        TDuration GetTimeout() const;

        void operator++();

        void Reset();

    private:
        TDuration Jitter(const TDuration timeout) const;

        TDuration Normalize(const TDuration timeout) const;

    private:
        TBackoffSettings Settings_;
        TDuration Timeout_;
    };
}
