#include "lock_file.h"

namespace NPassport::NLogstoreAgent {
    TLockFile::TLockFile(const TFsPath& dir) {
        Y_ENSURE(dir.Exists(),
                 "Path must exist: " << (TString)dir);
        Y_ENSURE(dir.IsDirectory(),
                 "Path must be directory: " << (TString)dir);

        File_ = TFile(dir / "lock", OpenAlways);
        File_.Flock(LOCK_EX | LOCK_NB);
    }
}
