#pragma once

#include "lock_file.h"

#include <optional>

namespace NPassport::NLogstoreAgent {
    class IStateHolder {
    public:
        struct TState {
            ui64 Offset = 0;
            ui64 Inode = 0;

            bool operator==(const TState& o) const;
        };

        virtual ~IStateHolder() = default;

        virtual std::optional<TState> Read() const = 0;
        virtual void Write(const TState& state) = 0;
    };

    class TDiskStateHolder: public IStateHolder, TNonCopyable {
    public:
        TDiskStateHolder(const TFsPath& dir);
        TDiskStateHolder(TDiskStateHolder&&) = delete;

        std::optional<TState> Read() const override;
        void Write(const TState& state) override;

    protected:
        static TState Parse(TStringBuf body);
        static TString Serialize(const TState& state);

    private:
        TLockFile Lock_; // Must be created first and deleted last
        TFile State_;
    };
}
