#include "throttled_state_holder.h"

namespace NPassport::NLogstoreAgent {
    TThrottledStateHolder::TThrottledStateHolder(const TFsPath& dir, TDuration timeout)
        : TDiskStateHolder(dir)
        , State_(TDiskStateHolder::Read())
        , Timeout_(timeout)
    {
    }

    TThrottledStateHolder::~TThrottledStateHolder() {
        Flush();
    }

    std::optional<IStateHolder::TState> TThrottledStateHolder::Read() const {
        return State_;
    }

    void TThrottledStateHolder::Write(const IStateHolder::TState& state) {
        State_ = state;

        if (TInstant::Now() - LastUpdate_ > Timeout_) {
            Flush();
        }
    }

    void TThrottledStateHolder::Write(size_t offset) {
        Y_ENSURE(State_, "There is no state: Inode must be specified");

        Write(IStateHolder::TState{
            .Offset = offset,
            .Inode = State_->Inode,
        });
    }

    void TThrottledStateHolder::Flush() {
        if (State_) {
            TDiskStateHolder::Write(*State_);
            LastUpdate_ = TInstant::Now();
        }
    }
}
