#pragma once

#include "state_holder.h"

#include <passport/infra/libs/cpp/utils/log/global.h>

#include <util/datetime/base.h>

namespace NPassport::NLogstoreAgent {
    // TODO: consider making it thread-safe to simplify access
    class TThrottledStateHolder: public TDiskStateHolder {
    public:
        explicit TThrottledStateHolder(const TFsPath& dir, TDuration timeout = TDuration::Seconds(10));
        ~TThrottledStateHolder() override;

        TThrottledStateHolder(TDiskStateHolder&&) = delete;

        std::optional<TState> Read() const override;

        void Write(const TState& state) override;
        void Write(size_t offset);

        void Flush();

    private:
        std::optional<TState> State_;
        TInstant LastUpdate_;

        const TDuration Timeout_;
    };
}
