#include <passport/infra/daemons/logstoreagent/src/cfg/runtime_context.h>

#include <passport/infra/libs/cpp/json/config.h>
#include <passport/infra/libs/cpp/utils/log/global.h>

#include <library/cpp/getopt/small/last_getopt.h>

using namespace NPassport;
using namespace NPassport::NLogstoreAgent;

void Check(const TString& configPath, TString& logFile) {
    const NJson::TConfig config = NJson::TConfig::ReadFromFile(configPath);

    const TString jpoint = "/service";

    // Do not spam into common file
    logFile = config.As<TString>(jpoint + "/checks_log");
    TRuntimeContext::InitLogger(logFile);

    TRuntimeContext runtime(config, jpoint);

    // TODO: call api (special?) handle to check ACL and params
}

int main(int argc, const char** argv) {
    TString logFile;
    try {
        TString configPath;

        NLastGetopt::TOpts opts;
        opts.AddHelpOption();
        opts.AddLongOption('c', "config", "")
            .StoreResult(&configPath)
            .DefaultValue("/etc/yandex/passport-logstoreagent/logstoreagent.conf");
        NLastGetopt::TOptsParseResult res(&opts, argc, argv);

        Check(configPath, logFile);
    } catch (const std::exception& e) {
        TStringStream msg;
        msg << "Failed to check configuration: " << e.what()
            << ". Check logs: '" << logFile << "'";

        TLog::Warning() << msg.Str();
        Cerr << msg.Str() << Endl;
        return -1;
    }

    return 0;
}
