#include <passport/infra/daemons/logstoreagent/src/utils/backoff.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/system/fs.h>

using namespace NPassport;
using namespace NPassport::NLogstoreAgent;

Y_UNIT_TEST_SUITE(Backoff) {
    Y_UNIT_TEST(Constant) {
        TBackoff b(
            {
                .Policy = EBackoffPolicy::Constant,
                .MinTimeout = TDuration::MilliSeconds(30),
            });
        UNIT_ASSERT_VALUES_EQUAL(TDuration::MilliSeconds(30), b.GetTimeout());
        ++b;
        UNIT_ASSERT_VALUES_EQUAL(TDuration::MilliSeconds(30), b.GetTimeout());
        b.Reset();
        UNIT_ASSERT_VALUES_EQUAL(TDuration::MilliSeconds(30), b.GetTimeout());
    }

    Y_UNIT_TEST(Linear) {
        TBackoff b(
            {
                .Policy = EBackoffPolicy::Linear,
                .MinTimeout = TDuration::MilliSeconds(30),
                .MaxTimeout = TDuration::MilliSeconds(90),
            });

        UNIT_ASSERT_VALUES_EQUAL(TDuration::MilliSeconds(30), b.GetTimeout());
        ++b;
        UNIT_ASSERT_VALUES_EQUAL(TDuration::MilliSeconds(60), b.GetTimeout());
        ++b;
        UNIT_ASSERT_VALUES_EQUAL(TDuration::MilliSeconds(90), b.GetTimeout());
        ++b;
        UNIT_ASSERT_VALUES_EQUAL(TDuration::MilliSeconds(90), b.GetTimeout());
        ++b;
        UNIT_ASSERT_VALUES_EQUAL(TDuration::MilliSeconds(90), b.GetTimeout());
        b.Reset();
        UNIT_ASSERT_VALUES_EQUAL(TDuration::MilliSeconds(30), b.GetTimeout());
    }

    Y_UNIT_TEST(Exponential) {
        TBackoff b(
            {
                .Policy = EBackoffPolicy::Exponential,
                .MinTimeout = TDuration::MilliSeconds(1),
                .MaxTimeout = TDuration::MilliSeconds(8),
            });

        UNIT_ASSERT_VALUES_EQUAL(TDuration::MilliSeconds(1), b.GetTimeout());
        ++b;
        UNIT_ASSERT_VALUES_EQUAL(TDuration::MilliSeconds(2), b.GetTimeout());
        ++b;
        UNIT_ASSERT_VALUES_EQUAL(TDuration::MilliSeconds(4), b.GetTimeout());
        ++b;
        UNIT_ASSERT_VALUES_EQUAL(TDuration::MilliSeconds(8), b.GetTimeout());
        ++b;
        UNIT_ASSERT_VALUES_EQUAL(TDuration::MilliSeconds(8), b.GetTimeout());
        b.Reset();
        UNIT_ASSERT_VALUES_EQUAL(TDuration::MilliSeconds(1), b.GetTimeout());
    }

    Y_UNIT_TEST(Jitter) {
        TBackoff b(
            {
                .Policy = EBackoffPolicy::Linear,
                .MinTimeout = TDuration::MilliSeconds(30),
                .MaxTimeout = TDuration::MilliSeconds(90),
                .Jitter = TDuration::MilliSeconds(5),
            });

        for (size_t i = 0; i < 1000; ++i) {
            UNIT_ASSERT_LE(TDuration::MilliSeconds(30), b.GetTimeout());
            UNIT_ASSERT_GE(TDuration::MilliSeconds(35), b.GetTimeout());
            ++b;
            UNIT_ASSERT_LE(TDuration::MilliSeconds(55), b.GetTimeout());
            UNIT_ASSERT_GE(TDuration::MilliSeconds(65), b.GetTimeout());
            ++b;
            UNIT_ASSERT_LE(TDuration::MilliSeconds(85), b.GetTimeout());
            UNIT_ASSERT_GE(TDuration::MilliSeconds(90), b.GetTimeout());
            b.Reset();
        }

        ++b;

        bool success;
        for (size_t i = 0; i < 1000; ++i) {
            success = (b.GetTimeout() != TDuration::MilliSeconds(60));
            if (success) {
                break;
            }
        }
        UNIT_ASSERT(success);
    }

    Y_UNIT_TEST(Parameters) {
        UNIT_ASSERT_EXCEPTION_CONTAINS(TBackoff({}), yexception, "Minimum timeout must be specified");
        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TBackoff({
                .MinTimeout = TDuration::MilliSeconds(2),
                .MaxTimeout = TDuration::MilliSeconds(1),
            }), yexception, "Max timeout cannot be smaller than min timeout");
        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TBackoff({
                .Policy = EBackoffPolicy::Linear,
                .MinTimeout = TDuration::MilliSeconds(30),
            }), yexception, "Maximum timeout must be specified, unless policy = Constant");
    }
}
